'
'   Define REGISTERS variable type.
'
TYPE REGISTERS
AX AS INTEGER
BX AS INTEGER
CX AS INTEGER
DX AS INTEGER
BP AS INTEGER
SI AS INTEGER
DI AS INTEGER
FLAGS AS INTEGER
DS AS INTEGER
ES AS INTEGER
END TYPE
DIM INREGS AS REGISTERS,OUTREGS AS REGISTERS
DIM OUTREGSAX AS INTEGER,OUTREGSBX AS INTEGER,OUTREGSCX AS INTEGER
DIM OUTREGSDX AS INTEGER,OUTREGSBP AS INTEGER,OUTREGSSI AS INTEGER
DIM OUTREGSDI AS INTEGER,OUTREGSDS AS INTEGER,OUTREGSES AS INTEGER
DIM OUTREGSFLAGS AS INTEGER,C AS STRING*1,I AS INTEGER
IF COMMAND$<>"" THEN
'
'  Replace commas in command-tail with spaces.
'
CMD$=""
FOR J=1 TO LEN(COMMAND$)
C=MID$(COMMAND$,J,1)
IF C="," THEN C=" "
CMD$=CMD$+C
NEXT J
'
'  Parse command-tail and set undefined registers to zero.
'
CALL PARSE(CMD$," ",A$,S$)
S$=LTRIM$(S$)
CALL PARSE(S$," ",AXS$,F$)
CALL PARSE(F$," ",BXS$,S$)
CALL PARSE(S$," ",CXS$,F$)
CALL PARSE(F$," ",DXS$,S$)
CALL PARSE(S$," ",BPS$,F$)
CALL PARSE(F$," ",SIS$,S$)
CALL PARSE(S$," ",DIS$,F$)
CALL PARSE(F$," ",DSS$,S$)
CALL PARSE(S$," ",ESS$,F$)
IF A$="" THEN A$="0"
IF AXS$="" THEN AXS$="0"
IF BXS$="" THEN BXS$="0"
IF CXS$="" THEN CXS$="0"
IF DXS$="" THEN DXS$="0"
IF BPS$="" THEN BPS$="0"
IF SIS$="" THEN SIS$="0"
IF DIS$="" THEN DIS$="0"
IF DSS$="" THEN DSS$="0"
IF ESS$="" THEN ESS$="0"
'
'  Clear screen by putting it into current mode.  (First use VESA bios
' calls.  If current mode integer is less than 256, screen mode is not a
' VESA mode or else system does not support VESA.  In case of the latter,
' use standard or VEGA bios call to put screen into current mode.  (A call
' to a non-existent VESA bios will generally leave a zero in bx and
' something other than 4Fh in ax.)  Similar things are done for VEGA
' systems.)
'
INREGS.AX=&H4F03
CALL INTERRUPTX(&H10,INREGS,OUTREGS)
INREGS.AX=&H4F02
INREGS.BX=OUTREGS.BX
VMODE=OUTREGS.BX
CALL INTERRUPTX(&H10,INREGS,OUTREGS)
IF VMODE<256 OR OUTREGS.AX<>&H4F THEN
INREGS.AX=&H6F00
CALL INTERRUPTX(&H10,INREGS,OUTREGS)
IF OUTREGS.BX=&H5637 THEN
INREGS.AX=&H6F04
CALL INTERRUPTX(&H10,INREGS,OUTREGS)
INREGS.AX=&H6F05
INREGS.BX=OUTREGS.AX-256*INT(OUTREGS.AX/256+.001)
CALL INTERRUPTX(&H10,INREGS,OUTREGS)
ELSE
INREGS.AX=&HF00
CALL INTERRUPTX(&H10,INREGS,OUTREGS)
INREGS.AX=OUTREGS.AX-256*INT(OUTREGS.AX/256+.001)
CALL INTERRUPTX(&H10,INREGS,OUTREGS)
END IF
END IF
'
'  Define interrupt and register variables.
'
I=VAL("&H"+LTRIM$(A$))
INREGS.AX=VAL("&H"+LTRIM$(AXS$))
INREGS.BX=VAL("&H"+LTRIM$(BXS$))
INREGS.CX=VAL("&H"+LTRIM$(CXS$))
INREGS.DX=VAL("&H"+LTRIM$(DXS$))
INREGS.BP=VAL("&H"+LTRIM$(BPS$))
INREGS.SI=VAL("&H"+LTRIM$(SIS$))
INREGS.DI=VAL("&H"+LTRIM$(DIS$))
INREGS.DS=VAL("&H"+LTRIM$(DSS$))
INREGS.ES=VAL("&H"+LTRIM$(ESS$))
'
'  Call user-specified interrupt.
'
CALL INTERRUPTX(I,INREGS,OUTREGS)
'
'  Save output register data.  (The call to BPRINT used to print them
' changes them.)
'
OUTREGSAX=OUTREGS.AX
OUTREGSBX=OUTREGS.BX
OUTREGSCX=OUTREGS.CX
OUTREGSDX=OUTREGS.DX
OUTREGSBP=OUTREGS.BP
OUTREGSSI=OUTREGS.SI
OUTREGSDI=OUTREGS.DI
OUTREGSDS=OUTREGS.DS
OUTREGSES=OUTREGS.ES
OUTREGSFLAGS=OUTREGS.FLAGS
'
'  Display output register data.  (Use bios print routine because bios was
' used to "change" screen modes above.  QB's PRINT routine doesn't
' necessarily know the screen exists.)
'
CALL BPRINT("AX = "+HEX$(OUTREGSAX),INREGS,OUTREGS)
CALL BPRINT("BX = "+HEX$(OUTREGSBX),INREGS,OUTREGS)
CALL BPRINT("CX = "+HEX$(OUTREGSCX),INREGS,OUTREGS)
CALL BPRINT("DX = "+HEX$(OUTREGSDX),INREGS,OUTREGS)
CALL BPRINT("BP = "+HEX$(OUTREGSBP),INREGS,OUTREGS)
CALL BPRINT("SI = "+HEX$(OUTREGSSI),INREGS,OUTREGS)
CALL BPRINT("DI = "+HEX$(OUTREGSDI),INREGS,OUTREGS)
CALL BPRINT("DS = "+HEX$(OUTREGSDS),INREGS,OUTREGS)
CALL BPRINT("ES = "+HEX$(OUTREGSES),INREGS,OUTREGS)
CALL BPRINT("FLAGS = "+HEX$(OUTREGSFLAGS),INREGS,OUTREGS)
ELSE
'
'  No arguments specified on command-line.  Print informational message.
'
CALL BPRINT(" ",INREGS,OUTREGS)
CALL BPRINT("COMMAND SYNTAX (use hexadecimal numbers):",INREGS,OUTREGS)
CALL BPRINT(" ",INREGS,OUTREGS)
CALL BPRINT("INTER interrupt_# ax bx cx dx bp si di ds es",INREGS,OUTREGS)
CALL BPRINT(" ",INREGS,OUTREGS)
CALL BPRINT("Use placeholders for unused registers.",INREGS,OUTREGS)
A$="(Don't need placeholders for unused registers at end.)"
CALL BPRINT(A$,INREGS,OUTREGS)
END IF
'
'  To keep QB from changing screen modes, don't let it use the END
' statement to terminate program.  Use another interrupt call instead.
' (END statement is still there to keep compiler from getting confused.)
'
INREGS.AX=&H4C00
CALL INTERRUPTX(&H21,INREGS,OUTREGS)
END
'
'  Bios print routine.
'
SUB BPRINT(S$,INREGS AS REGISTERS,OUTREGS AS REGISTERS)
DIM A(1 TO 21) AS LONG
DEF SEG=VARSEG(A(1))
OS=VARPTR(A(1))
FOR I=1 TO LEN(S$)
C$=MID$(S$,I,1)
POKE OS,ASC(C$)
OS=OS+1
NEXT I
POKE OS,13
OS=OS+1
POKE OS,10
OS=OS+1
POKE OS,ASC("$")
INREGS.AX=&H900
INREGS.DS=VARSEG(A(1))
INREGS.DX=VARPTR(A(1))
CALL INTERRUPTX(&H21,INREGS,OUTREGS)
END SUB
'
'  Parse input string S$ into S1$ and S2$, where DL$ is the DeLimiting
' character.
'
SUB PARSE(S$,DL$,S1$,S2$)
SI$=LTRIM$(RTRIM$(S$))
N=LEN(SI$)
S1$=SI$
S2$=""
IF N=0 THEN GOTO TERM
I=INSTR(SI$,DL$)
IF I=0 THEN GOTO TERM
S1$=MID$(SI$,1,I-1)
S2$=MID$(SI$,I+1,N-I)
TERM:
END SUB
